//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
//                                                                   FFVI Menu                                                                    \\
//                                                                    System                                                                      \\
//                                                                                                                                                \\
//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\

var gameClock = new Clock();
gameClock.start();

var pick1 = undefined;

function drawText(x, y, text, colour, fonty, colour2)
{
  var colourA = colour || white;
  var colourB = colour2 || black;
  var fontNew = fonty || font;
  var fontInner = fontNew.fontInner;
  var fontOutline = fontNew.fontOutline;
  fontInner.setColorMask(colourA);
  fontOutline.setColorMask(colourB);
  fontInner.drawText(x, y, text);
  fontOutline.drawText(x, y, text);
  fontInner.setColorMask(white);
  fontOutline.setColorMask(black);
}




function clockObject()
{
  this.x = 216;
  this.y = 136;
  this.w = 64;
  this.h = 32;
  this.font = font.fontInner;
  this.window = undefined;
}

clockObject.prototype.draw = function()
{
  drawWindow(this, this.x, this.y, this.w, this.h);
  drawText(this.x + 17, this.y + 8, "Time", lightBlue);
  drawText(this.x + 57 - this.font.getStringWidth(gameClock.getTime()), this.y + 16, gameClock.getTime())
}

function stepsGpObject()
{
  this.x = 208;
  this.y = 168;
  this.w = 72;
  this.h = 56;
  this.font = font.fontInner;
  this.window = undefined;
}

stepsGpObject.prototype.draw = function()
{
  drawWindow(this, this.x, this.y, this.w, this.h);
  drawText(this.x + 8, this.y + 8, "Steps", lightBlue);
  drawText(this.x + 64 - this.font.getStringWidth(steps), this.y + 16, steps)
  drawText(this.x + 8, this.y + 32, "Gp", lightBlue);
  drawText(this.x + 64 - this.font.getStringWidth(gp), this.y + 40, gp)
}




function windowObject(x, y, w, h, text, colour, xOffset, yOffset, reverse)
{
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  this.text = text || "";
  this.colour = colour;
  this.xOffset = xOffset || 0;
  this.yOffset = yOffset || 0;
  this.reverse = reverse || false;
  this.window = undefined;
}

windowObject.prototype.draw = function()
{
  drawWindow(this, this.x, this.y, this.w, this.h);
  drawText(this.x + this.xOffset, this.y + this.yOffset, this.text, this.colour);
}

function mpCostWindow(x, y, w, h, skill)
{
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  this.skill = skill;
  this.window = undefined;
}

mpCostWindow.prototype.draw = function()
{
  drawWindow(this, this.x, this.y, this.w, this.h);
  drawText(this.x + 8, this.y + 6, "MP", lightBlue);
  drawText(this.x + 24, this.y + 4, ".", lightBlue);
  drawText(this.x + 27, this.y + 4, ".", lightBlue);
  drawText(this.x + 30, this.y + 4, ".", lightBlue);
  if (this.skill[menus[10].selection].learn > 0)
  {
    drawText(this.x + 56 - font.fontInner.getStringWidth(this.skill[menus[10].selection].mpCost), this.y + 6, this.skill[menus[10].selection].mpCost);
  }
  else
  {
    drawText(this.x + 56 - font.fontInner.getStringWidth("0"), this.y + 6, "0");
  }
}







function actorStatus(menu, update) // For the status menu
{
  this.x = 8;
  this.y = 8;
  this.menu = menu;
  this.update = update;
  this.font = LoadFont("Final Fantasy VI - Menu Font.rfn");
}

actorStatus.prototype.draw = function()
{
  partyA[this.menu.selection].face.blit(this.x + 192, this.y + 41);
  drawText(this.x + 176, this.y + 72, partyA[this.menu.selection].name);
  drawText(this.x + 120, this.y + 96, "Vigor", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].vigor), this.y + 96, partyA[this.menu.selection].vigor);
  drawText(this.x + 120, this.y + 108, "Speed", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].speed), this.y + 108, partyA[this.menu.selection].speed);
  drawText(this.x + 120, this.y + 120, "Stamina", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].stamina), this.y + 120, partyA[this.menu.selection].stamina);
  drawText(this.x + 120, this.y + 132, "Mag.Pwr", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].magPwr), this.y + 132, partyA[this.menu.selection].magPwr);
  drawText(this.x + 120, this.y + 144, "Bat.Pwr", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].batPwr), this.y + 144, partyA[this.menu.selection].batPwr);
  drawText(this.x + 120, this.y + 156, "Defense", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].defence), this.y + 156, partyA[this.menu.selection].defence);
  drawText(this.x + 120, this.y + 168, "Evade %", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].evade), this.y + 168, partyA[this.menu.selection].evade);
  drawText(this.x + 120, this.y + 180, "Mag.Def", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].magDef), this.y + 180, partyA[this.menu.selection].magDef);
  drawText(this.x + 120, this.y + 192, "MBlock%", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].mBlock), this.y + 192, partyA[this.menu.selection].mBlock);
  for (var i = 0; i < 9; i++)
  {
    drawText(this.x + 200, this.y + 96 + (i * 12), ">", lightBlue);
  }
}

function actorDisplay(menu, x, y, w, h, party, window, yOffset, name) // For skills, party manager etc
{
  this.menu = menu;
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  this.party = party || partyA;
  this.windowShow = window;
  this.font = font.fontInner;
  this.yOffset = yOffset || 8;
  this.name = name || false;
  this.window = undefined;
}

actorDisplay.prototype.draw = function()
{
  if (this.windowShow) 
  {
    drawWindow(this, this.x, this.y, this.w, this.h);
  }
  if (this.party[this.menu.selection])
  {
    if (this.name)
    {
      drawText(this.x + 65, this.y + 28, this.party[this.menu.selection].name);
    }
    this.party[this.menu.selection].face.blit(this.x + 18, this.y + 8);
    drawText(this.x + 136, this.y + this.yOffset, "LV", lightBlue);
    drawText(this.x + 192 - this.font.getStringWidth(this.party[this.menu.selection].level), this.y + this.yOffset, this.party[this.menu.selection].level)
    drawText(this.x + 136, this.y + this.yOffset + 12, "HP", lightBlue);
    drawText(this.x + 192 - this.font.getStringWidth(this.party[this.menu.selection].hp), this.y + this.yOffset + 12, this.party[this.menu.selection].hp)
    drawText(this.x + 192, this.y + this.yOffset + 12, "/");
    drawText(this.x + 232 - this.font.getStringWidth(this.party[this.menu.selection].maxHp), this.y + this.yOffset + 12, this.party[this.menu.selection].maxHp)
    drawText(this.x + 136, this.y + this.yOffset + 24, "MP", lightBlue);
    drawText(this.x + 192 - this.font.getStringWidth(this.party[this.menu.selection].mp), this.y + this.yOffset + 24, this.party[this.menu.selection].mp)
    drawText(this.x + 192, this.y + this.yOffset + 24, "/");
    drawText(this.x + 232 - this.font.getStringWidth(this.party[this.menu.selection].maxMp), this.y + this.yOffset + 24, this.party[this.menu.selection].maxMp)
    if (this.party[this.menu.selection].esper)
    {
      drawText(this.x + 72, this.y + 8, this.party[this.menu.selection].esper.name);
    }
  }
}

function drawActorNameFace(x, y, actor)
{
  actor.face.blit(x, y);
  drawText(x - 4, y + 31, actor.name);
}



function itemDescription()
{
  this.menu = undefined
  this.x = 0;
  this.y = 0;
  this.w = 0;
  this.h = 0;
  this.xOffset = 8;
  this.yOffset = 8;
  this.text = ""
  this.pl = 0;
  this.lines = [];
  this.currentLine = 0;
  this.speed = 3;
  this.selection = undefined;
  this.window = undefined;
}

itemDescription.prototype.update = function()
{
  var numLines = this.lines.length - 1;
  if (this.lines[this.currentLine].position != this.lines[this.currentLine].line.length)
  {
    this.lines[this.currentLine].position += this.speed;
    if (this.lines[this.currentLine].position > this.lines[this.currentLine].line.length)
    {
      this.lines[this.currentLine].position = this.lines[this.currentLine].line.length;
    }
  }
  else
  {
    if (this.currentLine != numLines)
    {
      this.currentLine++;
    }
  }
}

itemDescription.prototype.updateDraw = function(x, y, w, h, current, item, menu)
{
  if (item[current] && this.text != item[current].info) this.selection = undefined;
  this.menu = menu;
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  
  drawWindow(this, this.x, this.y, this.w, this.h);
  
  if (this.selection != current)
  {
    this.selection = current;
    if (item[current] && item[current].info != undefined) 
    {
      this.text = item[current].info;
      this.updateString(); 
    }
    else 
    {
      this.text = undefined; 
    }
  }
  else if (this.text && !this.menu.done) {
    this.update();
    this.draw(); }
}

itemDescription.prototype.updateString = function()
{
  this.currentLine = 0;
  this.lines = [];
  for (var i = 0; i < this.text.length; i++)
  {
    var currentLetter = 0;
    var currentLine = 0;
    var lastSpace = 0;
    var string = new String(this.text);
    while (currentLetter < string.length)
    {
      currentLetter++;
      if (string.charAt(currentLetter) == '\n') 
      {
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
        lastSpace = currentLetter;
      }
      if (string.charAt(currentLetter) == ' ') 
      {
        lastSpace = currentLetter; 
      }
      if (messageFont.fontInner.getStringWidth(string.substring(0,currentLetter)) + this.xOffset > this.w - this.xOffset)
      {
        currentLetter = lastSpace;
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
      }
      if (currentLetter == string.length)
      {
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
      }
    }
  }
}

itemDescription.prototype.draw = function()
{
  for (var i = 0; i < this.lines.length; i++)
  {
    drawText(this.x + this.xOffset, this.y + this.yOffset + (i * 12), this.lines[i].line.substring(0, this.lines[i].position), white, messageFont);
  }
}



function cursorObject(x, y)
{
  this.cursor = LoadImage("Final Fantasy VI - Cursor.png");
  this.x = x || 0;
  this.y = y || 0;
}




function getVigor(actor, type)
{
  var base = actor.vigor;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].vigor;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getSpeed(actor, type)
{
  var base = actor.speed;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].speed;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getStamina(actor, type)
{
  var base = actor.stamina;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].stamina;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMagPwr(actor, type)
{
  var base = actor.magPwr;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].magPwr;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getBatPwr(actor, type)
{
  var base = actor.batPwr;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].batPwr;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getDefence(actor, type)
{
  var base = actor.defence;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].defence;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getEvade(actor, type)
{
  var base = actor.evade;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].evade;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMagDef(actor, type)
{
  var base = actor.magDef;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].magDef;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMBlock(actor, type)
{
  var base = actor.mBlock;
  
  for (var i = 0; i < 6; i++)
  {
    if (actor.equip[i] != undefined && type != i)
    {
      base += actor.equip[i].mBlock;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}


function baseObject(callback)
{
  this.x = 0;
  this.y = 0;
  this.width = 0;
  this.height = 0;
  this.callback = callback;
}


function menu(x, y, w, h, type)
{
  if (this instanceof menu == false) 
  {
    return new menu();
  }
  // PROPERTIES
  {
    this.name            = undefined;
    this.x               = x;
    this.y               = y;
    this.w               = w;
    this.h               = h;
    this.windowSkin      = true;
    this.window          = undefined;
    this.font            = font.fontInner;
    this.cursor          = new cursorObject();
    this.done            = true;
    this.items           = [];
    this.selectionMemory = 0;
    this.selection       = 0;
    this.columnSelection = 0;
    this.topSelectionMemory = 0;
    this.topSelection    = 0;
    this.shownItems      = 0;
    this.numColumns      = 0;
    this.type            = type || "normal";
    this.party           = partyA;
    this.yCorrection     = 0;
    this.currentColumn   = 0;
    this.showBorder      = false;
  }
  // OFFSETS AND SPACING
  {
    this.ySpacing       = 15;
    this.xSpacing       = 0;
    this.yOffset        = 13;
    this.xOffset        = 10;
    this.cursorXOffset  = 0;
    this.cursorYOffset  = 0;
  }
  // OTHER MENUS
  {
    //this.cursorClone = undefined;
    this.before = [];
    this.after = [];
  }
  
  this.escapeFunction = function() // The escape function
  {
    clearKeyQueue();
  }
  
  this.downFunction = function() {}
  this.upFunction = function() {}
  this.rightFunction = function() {}
  this.leftFunction = function() {}
  this.rFunction = function() {}
  this.lFunction = function() {} 
  
  this.functions = []; 
  
  this.textObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      drawText(x, y, this.name);
    }
  }
  
  this.inventoryObject = function(callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.type = partyItems;
    this.draw = function(x, y, item, menu)
    {      
      if (partyItems[item])
      {
        var colour = white;
        if (partyItems[item] instanceof itemObject == false) colour = grey;
        if (partyItems[item].icon) partyItems[item].icon.blitMask(x - 8, y, colour);
      
        drawText(x, y, partyItems[item].name, colour);
        drawText(x + 94, y, ":", colour);
        drawText(x + 118 - menu.font.getStringWidth(partyItems[item].quantity), y, partyItems[item].quantity, colour);
      }
    }
  }
  
  this.actorObject = function(callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.state = undefined;
    
    this.grabPanel = function(item)
    {
      partyA[item].panel = CreateSurface(162, 40, CreateColor(0, 0, 0, 0));
      partyA[item].panel.blitSurface(partyA[item].face, 0 + partyA[item].row, 0);
      partyA[item].panel.drawText(font, 50, 0, partyA[item].name);
      font.setColorMask(lightBlue);
      partyA[item].panel.drawText(font, 66, 16, "LV");
      partyA[item].panel.drawText(font, 66, 24, "HP");
      partyA[item].panel.drawText(font, 66, 32, "MP");
      font.setColorMask(white);
      partyA[item].panel.drawText(font, 121, 24, "/");
      partyA[item].panel.drawText(font, 121, 32, "/");
      partyA[item].panel.drawText(font, 122 - font2.getStringWidth(partyA[item].level), 16, partyA[item].level);
      partyA[item].panel.drawText(font, 122 - font2.getStringWidth(partyA[item].hp), 24, partyA[item].hp);
        
      partyA[item].panel.drawText(font, 162 - font2.getStringWidth(partyA[item].maxHp), 24, partyA[item].maxHp);
      partyA[item].panel.drawText(font, 122 - font2.getStringWidth(partyA[item].mp), 32, partyA[item].mp);
        
      partyA[item].panel.drawText(font, 162 - font2.getStringWidth(partyA[item].maxMp), 32, partyA[item].maxMp);
      partyA[item].panel.setBlendMode(REPLACE);
        
      if (partyA[item].state == "closeDown")
      {
        partyA[item].panel.rectangle(0, 0, 162, partyA[item].close, CreateColor(0, 0, 0, 0));
      }
      if (partyA[item].state == "closeUp")
      {
        partyA[item].panel.rectangle(0, 40 - partyA[item].close, 162, partyA[item].close, CreateColor(0, 0, 0, 0));
      }
      if (partyA[item].state == "openDown")
      {
        partyA[item].panel.rectangle(0, 0, 162, partyA[item].close, CreateColor(0, 0, 0, 0));
      }
      if (partyA[item].state == "openUp")
      {
        partyA[item].panel.rectangle(0, 40 - partyA[item].close, 162, partyA[item].close, CreateColor(0, 0, 0, 0));
      }
    }
    
    this.draw = function(x, y, item, menu)
    {
      if (partyA[item] != undefined)
      {
        if (partyA[item].state != this.state)
        {
          this.grabPanel(item);
          partyA[item].panel.blit(x, y);
        }
        else
        {
          partyA[item].face.blit(x + (0 + partyA[item].row), y);
          drawText(x + 50, y, partyA[item].name);
          drawText(x + 66, y + 16, "LV", lightBlue);
          drawText(x + 66, y + 24, "HP", lightBlue);
          drawText(x + 66, y + 32, "MP", lightBlue);
          drawText(x + 122 - font.fontInner.getStringWidth(partyA[item].level), y + 16, partyA[item].level);
          drawText(x + 122 - font.fontInner.getStringWidth(partyA[item].hp), y + 24, partyA[item].hp);
          drawText(x + 121, y + 24, "/");
          drawText(x + 162 - font.fontInner.getStringWidth(partyA[item].maxHp), y + 24, partyA[item].maxHp);
          drawText(x + 122 - font.fontInner.getStringWidth(partyA[item].mp), y + 32, partyA[item].mp);
          drawText(x + 121, y + 32, "/");
          drawText(x + 162 - font.fontInner.getStringWidth(partyA[item].maxMp), y + 32, partyA[item].maxMp);
        }
      }
    }
  }
  
  this.rareObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.type = rareItems;
    this.draw = function(x, y, item, menu)
    {
      if (partyRareItems[item])
      {
        drawText(x, y, rareItems[item].name);
      }
    }
  }
  
  this.equipmentObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item)
    {
      drawText(x, y, this.name, lightBlue);
      if (partyA[menus[1].selection].equip[item])
      {
        partyA[menus[1].selection].equip[item].icon.blit(x + 64 - 8, y);
        drawText(x + 64, y, partyA[menus[1].selection].equip[item].name);
      }
      else
      {
        if (item < 2)
        {
          drawText(x + 64, y, "Empty");
        }
      }
    }
  }
  
  this.relicObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item)
    {
      drawText(x, y, this.name, lightBlue);
      if (partyA[menus[1].selection].equip[item + 4])
      {
        partyA[menus[1].selection].equip[item + 4].icon.blit(x + 64 - 8, y);
        drawText(x + 64, y, partyA[menus[1].selection].equip[item + 4].name);
      }
      else
      {
        drawText(x + 64, y, "Empty");
      }
    }
  }

  this.fileObject = function(callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.draw = function(x, y, item, menu)
    {
      windowSkin.drawWindow(x - menu.xOffset, y, 240, 56);

      var file = OpenFile("File " + item);
  
      if (file.read("Empty", true) == false)
      {
        var name = file.read("name", undefined);
        drawText(x + 16, y + 14, name);
        drawText(x + 16, y + 32, "Time", lightBlue);
    
        var time = file.read("time", undefined);
        drawText(x + 48 - messageFont.fontInner.getStringWidth(time), y + 40, time);
        drawText(x + 192, y + 16, "LV", lightBlue);
    
        var lv = file.read("lv", undefined);
        drawText(x + 232 - messageFont.fontInner.getStringWidth(lv), y + 16, lv);
    
        var hp = file.read("hp", undefined);
        drawText(x + 192 - messageFont.fontInner.getStringWidth(hp), y + 32, hp);
        drawText(x + 192, y + 32, "/");
    
        var maxHp = file.read("maxHp", undefined);
        drawText(x + 232 - messageFont.fontInner.getStringWidth(maxHp), y + 32, maxHp);
    
        for (var i = 0; i < 4; i++)
        {
          var id = file.read("pos" + i, undefined);
          if (id != "undefined")
          {
            if (menu.selection == item)
            {
              menu.party[id].sprite.blit(x + 68 + (i * 24), y + 18);
            }
            else
            {
              menu.party[id].sprite.blitMask(x + 68 + (i * 24), y + 18, grey);
            }
          }
        }
      }
      else
      {
        drawText(x + 16, y + 14, "Empty");
      }
    }
  }

  this.esperObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.description = undefined;
    this.draw = function(x, y, item, menu)
    {
      if (partyEspers[item])
      {
        if (espers[item].equipTo)
        {
          drawText(x, y, espers[item].name, grey);
          drawText(x + 64, y - 2, ".", grey);
          drawText(x + 67, y - 2, ".", grey);
          drawText(x + 70, y - 2, ".", grey);
          drawText(x + 96 - font.fontInner.getStringWidth(espers[item].mpCost), y, espers[item].mpCost, grey);
        }
        else
        {
          drawText(x, y, espers[item].name);
          drawText(x + 64, y - 2, ".");
          drawText(x + 67, y - 2, ".");
          drawText(x + 70, y - 2, ".");
          drawText(x + 96 - font.fontInner.getStringWidth(espers[item].mpCost), y, espers[item].mpCost);
        }
      }
    }
  }
  
  this.magicObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.description = undefined;
    this.draw = function(x, y, item, menu)
    {
      if ((partyA[menus[1].selection].magic[item]).learn > 0 && (partyA[menus[1].selection].magic[item]).learn < 100)
      {
        partyA[menus[1].selection].magic[item].icon.blitMask(x - 8, y, grey, font, blueSub);
        drawText(x, y, partyA[menus[1].selection].magic[item].name, grey, font, blueSub);
        drawText(x + 47, y - 2, ".", grey, font, blueSub);
        drawText(x + 50, y - 2, ".", grey, font, blueSub);
        drawText(x + 53, y - 2, ".", grey, font, blueSub);
        drawText(x + 72 - font.fontInner.getStringWidth(partyA[menus[1].selection].magic[item].learn), y, partyA[menus[1].selection].magic[item].learn, grey, font, blueSub);
        drawText(x + 72, y, "%", grey, font, blueSub);
      }
      else if ((partyA[menus[1].selection].magic[item]).learn == 100)
      {
        partyA[menus[1].selection].magic[item].icon.blit(x - 8, y);
        drawText(x, y, partyA[menus[1].selection].magic[item].name);
      }
    }
  }
  
  this.swordTechObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.description = undefined;
    this.draw = function(x, y, item, menu)
    {
      if (partySwordTech[item])
      {
        drawText(x, y, partySwordTech[item].name);
      }
    }
  }
  
  this.blitzObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.description = undefined;
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      if (partyBlitz[item])
      {
        partyBlitz[item].image.blit(x, y);
      }
    }
  }
  
  this.loreObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.description = undefined;
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      if (partyLore[item])
      {
        drawText(x, y, skillLore[item].name);
        drawText(x + 80, y - 2, ".");
        drawText(x + 83, y - 2, ".");
        drawText(x + 86, y - 2, ".");
        drawText(x + 112 - font.fontInner.getStringWidth(skillLore[item].mpCost), y, skillLore[item].mpCost);
      }
    }
  }
  
  this.rageObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.description = undefined;
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      if (partyRage[item])
      {
        drawText(x, y, skillRage[item].name);
      }
    }
  }
  
  this.danceObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.description = undefined;
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      if (partyDance[item])
      {
        drawText(x, y, skillDance[item].name);
      }
    }
  }

  this.spriteObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      if (menu.party[item])
      {
        menu.party[item].sprite.blit(x, y);
      }
    }
  }
  
  this.equipItemObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      var colour = white;
      partyItems[name].icon.blit(x - 8, y);
      drawText(x, y, partyItems[name].name);
    }
  }
  
  this.esperSpellObject = function(esper, spell, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.esper = esper;
    this.spell = spell;
    this.draw = function(x, y, item, menu)
    {
      partyA[menus[1].selection].magic[spell].icon.blit(x, y);
      drawText(x + 8, y, partyA[menus[1].selection].magic[spell].name);
      drawText(x + 48 + 8, y, ":");
      drawText(x + 73 + 8, y, "*");
      drawText(x + 8 +96 - font.fontInner.getStringWidth(esper.learnRate), y, esper.learnRate);
      drawText(x + 8 + 168 - font.fontInner.getStringWidth(partyA[menus[1].selection].magic[spell].learn), y, partyA[menus[1].selection].magic[spell].learn);
      drawText(x + 8 + 168, y, "%");
    }
  }
  
  this.esperSubObject = function(name, callback)
  {
    this.inherit = baseObject;
    this.inherit(callback);
    this.name = name;
    this.draw = function(x, y, item, menu)
    {
      var colour = grey;
      if (partyEspers[menus[10].selection].equipTo == undefined)
      {
        colour = white;
      }
      drawText(x, y, this.name, colour);
      drawText(x + 72, y, "Learn.Rate");
      drawText(x + 160, y, "Skill");
    }
  }
}

menu.prototype.addEsperSpell = function(esper, spell, callback)
{
  return this.items[this.items.length] = new this.esperSpellObject(esper, spell, callback);
}

menu.prototype.initialize = function()
{
  for (var i = 0; i < 10; i++)
  {
    this.render();
    Rectangle(0, 0, 320, 240, CreateColor(0,0,0,255 - (i * (255 / 10))));
    if (this.showBorder)
    {
      this.border();
    }
    FlipScreen();
  }
  clearKeyQueue();
  this.done = false;
  this.execute();
}

menu.prototype.close = function(revert)
{
  for (var i = 0; i < 10; i++)
  {
    this.render();
    Rectangle(0, 0, 320, 240, CreateColor(0,0,0,0 + (i * (255 / 10))));
    if (this.showBorder)
    {
      this.border();
    }
    FlipScreen();
  }
  if (!revert)
  {
    this.changeAway();
  }
  clearKeyQueue();
  this.done = true;
}

menu.prototype.changeAway = function(revert)
{
  if (revert)
  {
    this.selection = this.selectionMemory;
    this.topSelection = this.topSelectionMemory;
    this.currentColumn = 0;
  }
  this.done = true;
}

menu.prototype.changeTo = function()
{
  this.done = false;
  this.execute();
}

menu.prototype.exitMenu = function()
{
  this.close();
  for (var i = 0; i < 10; i++)
  {
    RenderMap();
    Rectangle(0, 0, 320, 240, CreateColor(0,0,0,255 - (i * (255 / 10))));
    FlipScreen();
  }
  clearKeyQueue();
}

menu.prototype.openMenu = function()
{
  for (var i = 0; i < 10; i++)
  {
    RenderMap();
    Rectangle(0, 0, 320, 240, CreateColor(0,0,0,0 + (i * (255 / 10))));
    FlipScreen();
  }
  clearKeyQueue();
  this.initialize();
}

menu.prototype.updateItems = function()
{
  with (this)
  {
    for (var i = 0; i < items.length; i++)
    {
      //===Define the column======================================
      if (i == 0) // if there is only one item
      {
        {
          items[i].column = 0;
        }
      }
      else // if there is more than one column
      {
        if (items[i - 1].column + 1 > numColumns) // if the next column is more than the allowed
        {
          items[i].column = 0; // reset to 0 
        }
        else // otherwise...
        {
          items[i].column = items[i - 1].column + 1; // set column to the previous items value + 1
        }
      }
      //===Column defined=========================================
      if (i <= numColumns) // if items are less than number of columns
      {
        items[i].y = 0 //+ y_offset; // now we need to define the co-ords in here
      }
      else // otherwise...
      {
        if (numColumns == 0) // if columns is one the formula wont work so redevelop into
        {
          items[i].y = items[i - 1].y + ySpacing//- y_offset; // previous items y + y_spacing;
        }
        else // otherwise
        {
          items[i].y = items[i - (numColumns + 1)].y + ySpacing//- y_offset; // co-ords
        }
      }
      //========Y defined=========================================
      if (numColumns == 0)
      {
        items[i].x = (0 + (xSpacing * items[i].column));
      }
      else
      {
        if (items[i].column == 0)
        {
          items[i].x = 0;
        }
        else
        {
          items[i].x = (items[i - 1].x + font.getStringWidth(items[i - 1].name) + xSpacing);
        }
      }
      //========X defined=========================================
      items[i].width = font.getStringWidth(item.name); // gets the items width
      items[i].height = font.getHeight(); // gets the items height
    }
  }
}

menu.prototype.addItem = function(type, name, callback)
{
  if (type == "inventory") return this.items[this.items.length] = new this.inventoryObject(callback);
  if (type == "text") return this.items[this.items.length] = new this.textObject(name, callback);
  if (type == "actor") return this.items[this.items.length] = new this.actorObject(callback);
  if (type == "rare") return this.items[this.items.length] = new this.rareObject(name, callback);
  if (type == "equip") return this.items[this.items.length] = new this.equipmentObject(name, callback);
  if (type == "relic") return this.items[this.items.length] = new this.relicObject(name, callback);
  if (type == "file") return this.items[this.items.length] = new this.fileObject(callback);
  if (type == "esper") return this.items[this.items.length] = new this.esperObject(name, callback);
  if (type == "magic") return this.items[this.items.length] = new this.magicObject(name, callback);
  if (type == "swordTech") return this.items[this.items.length] = new this.swordTechObject(name, callback);
  if (type == "blitz") return this.items[this.items.length] = new this.blitzObject(name, callback);
  if (type == "lore") return this.items[this.items.length] = new this.loreObject(name, callback);
  if (type == "rage") return this.items[this.items.length] = new this.rageObject(name, callback);
  if (type == "dance") return this.items[this.items.length] = new this.danceObject(name, callback);
  if (type == "sprite") return this.items[this.items.length] = new this.spriteObject(name, callback);
  if (type == "equipItem") return this.items[this.items.length] = new this.equipItemObject(name, callback);
  if (type == "esperSub") return this.items[this.items.length] = new this.esperSubObject(name, callback);
}

menu.prototype.handleInput = function()
{
  with (this) 
  {
    // handle keypresses
    while (AreKeysLeft()) 
    {
      switch (GetKey()) 
      {
        case control.buttonDown: // If down key pressed
        {
          if (selection + numColumns < items.length - 1) // evaluate column change
          {
            selection += numColumns + 1;  // Change to next column
            if (selection >= topSelection + shownItems)
            {
              topSelection += 1 + numColumns;
            }
          }
          else // If not to change column
          {
            return downFunction();
          }
          break; // Break from loop
        }
        case control.buttonUp: // If up key pressed
        {
          if (selection > 0 + numColumns) // Work out move
          {
            selection -= numColumns + 1; // Move selection
            if (selection < topSelection)
            {
              topSelection -= 1 + numColumns;
            }
          }
          else // evaluate column change
          {
            if (items.length - ((selection - numColumns + 1) - (selection - numColumns + 1) - (selection - numColumns + 1)) - 2 < items.length) // Change to next column
            {
              return upFunction();
            }
          }
          break; // Break from loop
        }
        case control.buttonRight: // If right key pressed
        {
          if (currentColumn + 1 > numColumns)
          {
            return rightFunction();
          }
          else
          {
            if (selection < items.length - 1)
            {
              selection++;
              currentColumn++;
            }
          }
          break; // Break loop
        }
        case control.buttonLeft: // If left key pressed
        {
          if (currentColumn - 1 < 0)
          {
            return leftFunction();
          }
          else
          {
            if (selection > 0)
            {
              selection--;
              currentColumn--;
            }
          }
          break; // Break from loop
        }
        case control.buttonL: // L
        {
          return lFunction()
        }
        case control.buttonR: // R
        {
          return rFunction();
        }
        case control.buttonA:
        {
          if (items.length > 0)
          {
            return items[selection].callback();
          }
          else
          {
            return
          }
        }
        case control.buttonB: 
        {
          return this.escapeFunction();
        }
      }
      // end handle input
    }
  }
}

menu.prototype.draw = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing) * (this.numColumns + 1);
  
  drawWindow(this, this.x, this.y, this.w, this.h);
  
  if (this.type == "normal") this.drawNormal();
  if (this.type == "itemInfo") this.drawItemInfo(menus[4].selection);
  if (this.type == "status") this.drawStatus();
}

menu.prototype.drawItemType = function()
{  
  var temp = this.topSelection / (this.numColumns + 1)
  for (var i = 0; i < this.shownItems; i++)
  {
    if (i < this.items.length)
    {
      var item = i + this.topSelection;
      var x = this.x + this.xOffset + this.items[item].x;
      var y = this.y + this.yOffset + this.items[item].y - ((temp) * this.ySpacing);
      
      this.items[i + this.topSelection].draw(x, y, item, this);
    }
  }
}

menu.prototype.drawNormal = function()
{
  this.drawItemType();
}

menu.prototype.drawActorStatusEquip = function(full, ext)
{
  var ext = ext || 0;
  var y = this.y + 72;
  drawText(this.x + 120, y + 8, "Vigor", lightBlue);
  var temp = getVigor(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 8, temp);
  drawText(this.x + 120, y + 20, "Speed", lightBlue);
  temp = getSpeed(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 20, temp);
  drawText(this.x + 120, y + 32, "Stamina", lightBlue);
  temp = getStamina(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 32, temp);
  drawText(this.x + 120, y + 44, "Mag.Pwr", lightBlue);
  temp = getMagPwr(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 44, temp);
  drawText(this.x + 120, y + 56, "Bat.Pwr", lightBlue);
  temp = getBatPwr(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 56, temp);
  drawText(this.x + 120, y + 68, "Defense", lightBlue);
  temp = getDefence(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 68, temp);
  drawText(this.x + 120, y + 80, "Evade %", lightBlue);
  temp = getEvade(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 80, temp);
  drawText(this.x + 120, y + 92, "Mag.Def", lightBlue);
  temp = getMagDef(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 92, temp);
  drawText(this.x + 120, y + 104, "MBlock%", lightBlue);
  temp = getMBlock(partyA[menus[1].selection]);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 104, temp);
  for (var i = 0; i < 9; i++)
  {
    drawText(this.x + 200, y + 8 + (i * 12), ">", lightBlue);
  }
  if (!full.done)
  {
    var temp = getVigor(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].vigor;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getVigor(partyA[menus[1].selection])) colour = yellow;
    if (temp < getVigor(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 8, temp, colour);
    var temp = getSpeed(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].speed;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getSpeed(partyA[menus[1].selection])) colour = yellow;
    if (temp < getSpeed(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 20, temp, colour);
    var temp = getStamina(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].stamina;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getStamina(partyA[menus[1].selection])) colour = yellow;
    if (temp < getStamina(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 32, temp, colour);
    var temp = getMagPwr(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].magPwr;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMagPwr(partyA[menus[1].selection])) colour = yellow;
    if (temp < getMagPwr(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 44, temp, colour);
    var temp = getBatPwr(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].batPwr;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getBatPwr(partyA[menus[1].selection])) colour = yellow;
    if (temp < getBatPwr(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 56, temp, colour);
    var temp = getDefence(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].defence;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getDefence(partyA[menus[1].selection])) colour = yellow;
    if (temp < getDefence(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 68, temp, colour);
    var temp = getEvade(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].evade;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getEvade(partyA[menus[1].selection])) colour = yellow;
    if (temp < getEvade(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 80, temp, colour);
    var temp = getMagDef(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].magDef;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMagDef(partyA[menus[1].selection])) colour = yellow;
    if (temp < getMagDef(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 92, temp, colour);
    var temp = getMBlock(partyA[menus[1].selection], this.selection + ext) + partyItems[full.items[full.selection].name].mBlock;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMBlock(partyA[menus[1].selection])) colour = yellow;
    if (temp < getMBlock(partyA[menus[1].selection])) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 104, temp, colour);
  }
}

menu.prototype.drawItemStats = function(x, y)
{
  drawWindow(x, y, 120, 208);
  drawText(x + 8, y + 92, "Vigor", lightBlue);
  drawText(x + 72, y + 89, ".", lightBlue); drawText(x + 76, y + 89, ".", lightBlue); 
  drawText(x + 8, y + 104, "Speed", lightBlue);
  drawText(x + 72, y + 101, ".", lightBlue); drawText(x + 76, y + 101, ".", lightBlue); 
  drawText(x + 8, y + 116, "Stamina", lightBlue);
  drawText(x + 72, y + 113, ".", lightBlue); drawText(x + 76, y + 113, ".", lightBlue); 
  drawText(x + 8, y + 128, "Mag.Pwr", lightBlue);
  drawText(x + 72, y + 125, ".", lightBlue); drawText(x + 76, y + 125, ".", lightBlue); 
  drawText(x + 8, y + 140, "Bat.Pwr", lightBlue);
  drawText(x + 72, y + 137, ".", lightBlue); drawText(x + 76, y + 137, ".", lightBlue); 
  drawText(x + 8, y + 152, "Defense", lightBlue);
  drawText(x + 72, y + 149, ".", lightBlue); drawText(x + 76, y + 149, ".", lightBlue); 
  drawText(x + 8, y + 166, "Evade %", lightBlue);
  drawText(x + 72, y + 163, ".", lightBlue); drawText(x + 76, y + 163, ".", lightBlue); 
  drawText(x + 8, y + 178, "Mag.Def", lightBlue);
  drawText(x + 72, y + 175, ".", lightBlue); drawText(x + 76, y + 175, ".", lightBlue); 
  drawText(x + 8, y + 190, "MBlock%", lightBlue);
  drawText(x + 72, y + 187, ".", lightBlue); drawText(x + 76, y + 187, ".", lightBlue); 
}

menu.prototype.drawItemInfo = function(selection)
{
  descriptionWindow.updateDraw(40, 48, 240, 40, selection, partyItems, this);
  drawWindow(this.x, this.y, this.w, this.h);
  
  //drawText(this.x + 8, this.y + 8, "Attack", lightBlue);
  
  partyItems[selection].icon.blitMask(this.x + 8, this.y + 56, lightBlue);
  drawText(this.x + 16, this.y + 56, partyItems[selection].name + " can be used by:", lightBlue);
  
  var line = 0;
  var column = 0;
  for (var i = 0; i < partyItems[selection].equip.length; i++)
  {
    drawText(this.x + 16 + (column * 80), this.y + 68 + (line * 12), actor[partyItems[selection].equip[i]].name);
    column++;
    if (column > 2)
    {
      column = 0;
      line++
    }
  }
  this.drawItemStats(this.x - 120, 16);
}

menu.prototype.drawStatus = function()
{
  var actor = this.party[this.actor];
  
  drawText(this.x + 16 + (12 * actor.row), this.y + 30, actor.name);  
  
  actor.face.blit(this.x + 6, this.y + 49);
  drawText(this.x + 72, this.y + 46, "LV", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(actor.level), this.y + 46, actor.level);
  drawText(this.x + 72, this.y + 54, "HP", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(actor.hp), this.y + 54, actor.hp);
  drawText(this.x + 128, this.y + 54, "/");
  drawText(this.x + 168 - this.font.getStringWidth(actor.maxHp), this.y + 54, actor.maxHp);
  drawText(this.x + 72, this.y + 62, "MP", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(actor.mp), this.y + 62, actor.mp);
  drawText(this.x + 128, this.y + 62, "/");
  drawText(this.x + 168 - this.font.getStringWidth(actor.maxMp), this.y + 62, actor.maxMp);
  
  drawText(this.x + 8, this.y + 96, "Your Exp:", lightBlue);
  drawText(this.x + 110 - this.font.getStringWidth(actor.exp), this.y + 108, actor.exp);
  
  drawText(this.x + 8, this.y + 120, "For level up:", lightBlue);
  drawText(this.x + 110 - this.font.getStringWidth((actor.nextExp - actor.exp)), this.y + 132, (actor.nextExp - actor.exp));
  
  drawText(this.x + 16, this.y + 156, "Vigor", lightBlue);
  drawText(this.x + 72, this.y + 153, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getVigor(actor)), this.y + 156, getVigor(actor));
  
  drawText(this.x + 16, this.y + 168, "Speed", lightBlue);
  drawText(this.x + 72, this.y + 165, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getSpeed(actor)), this.y + 168, getSpeed(actor));
  
  drawText(this.x + 16, this.y + 180, "Stamina", lightBlue);
  drawText(this.x + 72, this.y + 177, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getStamina(actor)), this.y + 180, getStamina(actor));
  
  drawText(this.x + 120, this.y + 144, "Bat.Pwr", lightBlue);
  drawText(this.x + 192, this.y + 141, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getBatPwr(actor)), this.y + 144, getBatPwr(actor));
  
  drawText(this.x + 16, this.y + 192, "Mag.Pwr", lightBlue);
  drawText(this.x + 72, this.y + 189, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getMagPwr(actor)), this.y + 192, getMagPwr(actor))
  
  drawText(this.x + 120, this.y + 156, "Defense", lightBlue);
  drawText(this.x + 192, this.y + 153, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getDefence(actor)), this.y + 156, getDefence(actor));
  
  drawText(this.x + 120, this.y + 168, "Evade %", lightBlue);
  drawText(this.x + 192, this.y + 165, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getEvade(actor)), this.y + 168, getEvade(actor));
  drawText(this.x + 224, this.y + 168, "%");
  
  drawText(this.x + 120, this.y + 180, "Mag.Def", lightBlue);
  drawText(this.x + 192, this.y + 177, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getMagDef(actor)), this.y + 180, getMagDef(actor));
  
  drawText(this.x + 120, this.y + 192, "MBlock%", lightBlue);
  drawText(this.x + 192, this.y + 189, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getMBlock(actor)), this.y + 192, getMBlock(actor));
  drawText(this.x + 224, this.y + 192, "%");
  
  drawWindow(actor, this.x + 128, this.y + 72, 88, 64);
}

menu.prototype.drawPartyChanger = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);

      if (this.party[i])
      {
        this.drawSprite(x, y, this.party[i].id);
      }

      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
}

menu.prototype.render = function()
{
  for (var i = 0; i < this.before.length; i++) {
    this.before[i](); }
  this.draw();
  for (var i = 0; i < this.functions.length; i++)
    {
      this.functions[i]();
    }
  for (var i = 0; i < this.after.length; i++) {
    this.after[i](); }
    
  if (this.showBorder)
  {
    this.border();
  }
    
  var temp = this.topSelection / (this.numColumns + 1)
  if (!this.done && this.items.length > 0) {
    this.cursor.x = this.x + this.items[this.selection].x - this.xOffset + this.cursorXOffset;
    this.cursor.y = this.y + this.items[this.selection].y + this.yOffset - (temp * this.ySpacing) + this.cursorYOffset;
    this.cursor.cursor.blit(this.cursor.x, this.cursor.y); }
}

menu.prototype.border = function()
{
  Rectangle(0, 0, 40, 240, black);
  Rectangle(280, 0, 40, 240, black);
}

menu.prototype.execute = function()
{
  while(!this.done)
  {
    this.render();
    FlipScreen();
    this.handleInput();
  }
}













var partyMenu = false;

var menus = [];

// MAIN MENU
{
  menus[0] = new menu(216, 16, 64, 120, "normal");
  menus[0].addItem("text", "Item", function() 
  {
    menus[0].close(); menus[4].done = false; menus[4].initialize(); 
  }
  );
  menus[0].addItem("text", "Skills", function() 
  {
    menus[0].changeAway(); partyMenu = false; menus[1].changeTo(); 
  }
  );
  menus[0].addItem("text", "Equip", function() 
  {
    menus[0].changeAway(); partyMenu = false; menus[1].changeTo(); 
  }
  );
  menus[0].addItem("text", "Relic", function() 
  {
    menus[0].changeAway(); partyMenu = false; menus[1].changeTo(); 
  }
  );
  menus[0].addItem("text", "Status", function() 
  {
    menus[0].changeAway(); partyMenu = false; menus[1].changeTo(); 
  }
  );
  menus[0].addItem("text", "Config", function() 
  {
    menus[0].close(); menus[24].initialize(); 
  }
  );
  menus[0].addItem("text", "Save", function() 
  {
    menus[0].close(); menus[26].initialize(); 
  }
  );
  menus[0].before = [function() 
  {
    menus[37].draw()
  }
  , function() 
  {
    menus[1].draw()
  }
  ]
  menus[0].after = [function() 
  {
    menus[2].draw()
  }
  , function() 
  {
    menus[3].draw()
  }
  ];
  menus[0].showBorder = true;
  menus[0].escapeFunction = function() 
  {
    menus[0].exitMenu();
    for (var i = 0; i < menus.length; i++)
    {
      menus[i].selection = 0;
    }
    menus[0].done = true;
  }
  menus[0].leftFunction = function()
  {
    menus[0].done = true;
    menus[1].done = false;
    for (var i = 0; i < 9; i++)
    {
      menus[0].x += 8;
      menus[1].x += 8;
      menus[2].x += 8;
      menus[3].x += 8;
      menus[37].x += 8;
      menus[0].render();
      menus[0].border();
      FlipScreen();
    }
    partyMenu = true;
    clearKeyQueue();
    menus[1].execute();
  }
  menus[0].updateItems();
}

// PARTY MENU
{
  menus[1] = new menu(40,16, 240, 208);
  menus[1].addItem("actor", undefined, function() 
  {
    partyPick() 
  }
  );
  menus[1].addItem("actor", undefined, partyPick);
  menus[1].addItem("actor", undefined, partyPick);
  menus[1].addItem("actor", undefined, partyPick);
  menus[1].ySpacing = 48;
  menus[1].yOffset = 14;
  menus[1].xOffset = 6;
  menus[1].before = [function() 
  {
    menus[37].draw()
  }
  ];
  menus[1].after = [function() 
  {
    menus[0].draw()
  }
  , function() 
  {
    menus[2].draw()
  }
  , function() 
  {
    menus[3].draw()
  }
  ];
  menus[1].showBorder = true;
  menus[1].escapeFunction = function() 
  {
    if (partyMenu)
    {
      menus[1].rightFunction();
    }
    else
    {
      menus[1].changeAway(true); 
      menus[0].changeTo(); 
    }
  }
  menus[1].rightFunction = function()
  {
    menus[1].done = true;
    menus[0].done = false;
    for (var i = 0; i < 9; i++)
    {
      menus[0].x -= 8;
      menus[1].x -= 8;
      menus[2].x -= 8;
      menus[3].x -= 8;
      menus[37].x -= 8;
      menus[0].render();
      menus[0].border();
      FlipScreen();
    }
    partyMenu = false;
    clearKeyQueue();
    menus[0].execute();
  }
  menus[1].updateItems();
}

// TIME WINDOW
{
  menus[2] = new clockObject(); // Time window
}

// STEPS AND GP WINDOW
{
  menus[3] = new stepsGpObject(); // Steps and GP window
}

// ITEM MENU
{
  menus[4] = new menu(40, 88, 240, 136);
  for (var i = 0; i < gameItems.length; i++)
  {
    menus[4].addItem("inventory", undefined, useItem);
  }
  menus[4].ySpacing = 12;
  menus[4].xOffset = 25;
  menus[4].yOffset = 12;
  menus[4].before = [function() 
  {
    descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
  }
  ];
  menus[4].after = [function() 
  {
    menus[5].draw()
  }
  , function() 
  {
    menus[6].draw()
  }
  ];
  menus[4].cursorXOffset = 24;
  menus[4].escapeFunction = function() 
  {
    descriptionWindow.text = "";
    menus[4].done = true; 
    menus[5].done = false; 
    menus[5].before = [function() 
    {
      menus[4].draw()
    }
    , function() 
    {
      menus[6].draw()
    }
    , function() 
    {
      descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
    }
    ]; menus[5].execute(); 
  }
  menus[4].updateItems();
}

// ITEM TOP MENU
{
  menus[5] = new menu(88, 16, 192, 32);
  menus[5].addItem("text", "USE", function() 
  {
    menus[5].changeAway(); menus[4].done = false; menus[4].execute(); 
  }
  );
  menus[5].addItem("text", "ARRANGE", arrange);
  menus[5].addItem("text", "RARE", function() 
  {
    menus[5].changeAway(), menus[8].done = false;  menus[8].execute(); 
  }
  );
  menus[5].numColumns = 2;
  menus[5].xSpacing = 16;
  menus[5].xOffset = 24;
  menus[5].yOffset = 16;
  menus[5].before = [function()
  {
    menus[6].draw();
  }
  ,
  function() 
  {
    descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
  }
  ];
  menus[5].escapeFunction = function() 
  {
    menus[5].close();; descriptionWindow.text = ""; menus[0].initialize(); 
  }
  menus[5].updateItems();
}

// ITEM TOP LEFT WINDOW
{
  menus[6] = new windowObject(40, 16, 48, 32, "Item", lightBlue, 10, 16);
}

// ITEM DESCRIPTION WINDOW
{
  var descriptionWindow = new itemDescription();
}

// ITEM SUB MENU
{
  menus[7] = new menu(40, 88, 240, 136, "itemInfo");
  menus[7].before = [function() 
  {
    menus[5].draw();
  }
  , function() 
  {
    menus[6].draw();
  }
  ];
  menus[7].escapeFunction = function() 
  {
    pick1 = undefined; menus[4].cursorClone = undefined; menus[7].done = true, menus[4].done = false, menus[4].execute(); 
  }
}

// RARE ITEM MENU
{
  menus[8] = new menu(40, 88, 240, 136);
  menus[8].after = [function()
  {
    menus[5].draw();
  }
  , function()
  {
    menus[6].draw();
  }
  , function() 
  {
    descriptionWindow.updateDraw(40, 48, 240, 40, menus[8].selection, partyRareItems, menus[8])
  }
  ];
  menus[8].numColumns = 1;
  menus[8].xSpacing = 112;
  menus[8].xOffset = 16;
  menus[8].ySpacing = 12;
  menus[8].yOffset = 12;
  var column = 0;
  var line = 0;
  for (var i = 0; i < 20; i++)
  {
    menus[8].addItem("rare", rareItems[i].name, function() 
    {
    }
    );
    menus[8].items[i].x = 0 + (menus[8].xSpacing * column);
    menus[8].items[i].y = 0 + (menus[8].ySpacing * line);
    column++;
    if (column > 1)
    {
      column = 0;
      line++;
    }
  }
  menus[8].escapeFunction = function() 
  {
    descriptionWindow.text = ""; 
    menus[8].done = true; 
    menus[5].done = false, 
    menus[5].before = [function()
    {
      menus[8].draw();
    }
    , function()
    {
      menus[6].draw();
    }
    , function() 
    {
      descriptionWindow.updateDraw(40, 48, 240, 40, menus[8].selection, partyRareItems, menus[8])
    }
    ]; 
    menus[5].execute(); 
  }
}

// RARE ITEM DECRIPTION ================= NOT NEEDED ===================
{
  menus[9] = new itemDescription(partyRareItems, menus[8], 8, 40, 240, 40, true);
}

// SKILLS MENU
{
  menus[10] = new menu(40, 112, 240, 112);
  menus[10].before = [function()
  {
    menus[12].draw();
  }
  , function()
  {
    drawWindow(descriptionWindow, 40, 16, 240, 40);
  }
  , function()
  {
    if (!menus[10].done && menus[10].items[menus[10].selection].description)
    {
      descriptionWindow.updateDraw(40, 16, 240, 40, menus[10].selection, menus[10].items[menus[10].selection].description, menus[10]);
    }
  }
  ];
  menus[10].after = [function()
  {
    menus[36].draw();
  }
  ];
  menus[10].cursorXOffset = 32;
}

// SKILLS DESCRIPTION =============== NOT NEEDED ===============
{
  menus[11] = new windowObject(40, 16, 240, 40);
}

// SKILLS ACTOR
{
  menus[12] = new actorDisplay(menus[1], 40, 56, 240, 56, partyA, true);
}

// SKILLS MENU TOP
{
  menus[13] = new menu(40, 16, 72, 48);
  menus[13].addItem("text", "Espers", function() 
  {
    skillsEspers(13) 
  }
  );
  menus[13].addItem("text", "Magic", function() 
  {
    skillsMagic(13) 
  }
  );
  menus[13].before = [function()
  {
    menus[10].draw();
  }
  , function()
  {
    //menus[11].draw();  //=========================================================================================================
  }
  , function()
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, menus[13].selection, "", menus[13]);
  }
  , function()
  {
    menus[12].draw();
  }
  ];
  menus[13].after = [function()
  {
    menus[14].draw();
  }
  ];
  menus[13].downFunction = function() 
  {
    menus[13].done = true; menus[14].done = false; menus[14].execute(); 
  }
  menus[13].escapeFunction = function() 
  {
    menus[13].close(); menus[0].initialize(); 
  }
  menus[13].updateItems();
  
  menus[13].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[13].close();
        menus[1].selection = temp - 1;
        return menus[13].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[13].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[13].close();
        menus[1].selection = temp + 1;
        return menus[13].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// SKILLS MENU BOTTOM
{
  menus[14] = new menu(40, 64, 72, 96)
  menus[14].addItem("text", "SwdTech", function() 
  {
    skillsSwordTech(13); 
  }
  );
  menus[14].addItem("text", "Blitz", function() 
  {
    skillsBlitz(13); 
  }
  );
  menus[14].addItem("text", "Lore", function() 
  {
    skillsLore(13); 
  }
  );
  menus[14].addItem("text", "Rage", function() 
  {
    skillsRage(13); 
  }
  );
  menus[14].addItem("text", "Dance", function() 
  {
    skillsDance(13); 
  }
  );
  menus[14].before = [function()
  {
    menus[10].draw();
  }
  , function()
  {
    //menus[11].draw(); =============================================================================================================
  }
  , function()
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, menus[13].selection, "", menus[13]);
  }
  , function()
  {
    menus[12].draw();
  }
  , function()
  {
    menus[13].draw();
  }
  ];
  menus[14].escapeFunction = function() 
  {
    menus[14].close(); menus[0].initialize(); 
  }
  menus[14].upFunction = function() 
  {
    menus[14].done = true; menus[13].done = false; menus[13].execute(); 
  }
  menus[14].updateItems();
  
  menus[14].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[14].close();
        menus[1].selection = temp - 1;
        return menus[14].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[14].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[14].close();
        menus[1].selection = temp + 1;
        return menus[14].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// EQUIP TOP MENU
{
  menus[15] = new menu(40, 16, 240, 32);
  menus[15].addItem("text", "EQUIP", function() 
  {
    menus[15].done = true; menus[16].done = false; menus[18].text = "EQUIP"; menus[16].execute(); 
  }
  );
  menus[15].addItem("text", "OPTIMUM", function() 
  {
    optimize(partyA[menus[1].selection]); 
  }
  );
  menus[15].addItem("text", "RMOVE", function() 
  {
    menus[15].done = true; menus[16].done = false; menus[18].text = "REMOVE"; menus[16].execute(); 
  }
  );
  menus[15].addItem("text", "EMPTY", function() 
  {
    removeAll(partyA[menus[1].selection]) 
  }
  );
  menus[15].numColumns = 3;
  menus[15].xOffset = 8;
  menus[15].yOffset = 12;
  menus[15].xSpacing = 16;
  menus[15].before = [function()
  {
    menus[17].draw();
  }
  , function()
  {
    menus[16].draw();
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[15].escapeFunction = function() 
  {
    menus[15].close(); menus[0].initialize(); 
  }
  menus[15].updateItems();
  
  menus[15].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[15].close();
        menus[1].selection = temp - 1;
        return menus[15].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[15].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[15].close();
        menus[1].selection = temp + 1;
        return menus[15].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// EQUIP MENU
{
  menus[16] = new menu(40, 32, 240, 72); // this will be wrong
  menus[16].addItem("equip", "R-hand", function() 
  {
    if (menus[15].selection == 0) 
    {
      equipItems(0)
    }
    else 
    {
      removeEquipment(0); 
    }
  }
  );
  menus[16].addItem("equip", "L-hand", function() 
  {
    if (menus[15].selection == 0) 
    {
      equipItems(1)
    }
    else 
    {
      removeEquipment(1); 
    }
  }
  );
  menus[16].addItem("equip", "Head", function() 
  {
    if (menus[15].selection == 0) 
    {
      equipItems(2)
    }
    else 
    {
      removeEquipment(2); 
    }
  }
  );
  menus[16].addItem("equip", "Body", function() 
  {
    if (menus[15].selection == 0) 
    {
      equipItems(3)
    }
    else 
    {
      removeEquipment(3); 
    }
  }
  );
  menus[16].yOffset = 20;
  menus[16].ySpacing = 12;
  menus[16].before = [function()
  {
    menus[17].draw();
  }
  ];
  menus[16].after = [function()
  {
    menus[18].draw();
  }
  , function()
  {
    menus[16].drawActorStatusEquip(menus[17]);
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[16].escapeFunction = function() 
  {
    menus[16].done = true; menus[15].done = false; menus[15].execute(); 
  }
  menus[16].updateItems();
  
  menus[16].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[16].close();
        menus[1].selection = temp - 1;
        return menus[16].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[16].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[16].close();
        menus[1].selection = temp + 1;
        return menus[16].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// EQUIP ITEM MENU
{
  menus[17] = new menu(40, 104, 240, 120);
  menus[17].xOffset = 16;
  menus[17].yOffset = 8;
  menus[17].ySpacing = 12;
  menus[17].cursorXOffset = 24;
  menus[17].after = [function()
  {
    menus[16].draw();
  }
  , function()
  {
    menus[18].draw();
  }
  , function()
  {
    menus[16].drawActorStatusEquip(menus[17]);
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[17].escapeFunction = function() 
  {
    menus[17].done = true; menus[17].items = []; menus[17].selection = 0; menus[17].topSelection = 0; menus[16].done = false; menus[16].execute(); 
  }
}

// EQUIP TOP LEFT WINDOW
{
  menus[18] = new windowObject(216, 16, 64, 32, undefined, lightBlue, 8, 12);
}

// RELIC TOP MENU
{
  menus[19] = new menu(40, 16, 240, 32);
  menus[19].addItem("text", "EQUIP", function() 
  {
    menus[19].done = true; menus[20].done = false; menus[18].text = "EQUIP"; menus[20].execute(); 
  }
  );
  menus[19].addItem("text", "REMOVE", function() 
  {
    menus[19].done = true; menus[20].done = false; menus[18].text = "EQUIP"; menus[20].execute(); 
  }
  );
  menus[19].numColumns = 1;
  menus[19].xOffset = 8;
  menus[19].yOffset = 12;
  menus[19].xSpacing = 16;
  menus[19].before = [function()
  {
    menus[21].draw();
  }
  , function()
  {
    menus[20].draw();
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[19].escapeFunction = function() 
  {
    menus[19].close(); menus[0].initialize(); 
  }
  menus[19].updateItems();
  
  menus[19].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[19].close();
        menus[1].selection = temp - 1;
        return menus[19].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[19].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[19].close();
        menus[1].selection = temp + 1;
        return menus[19].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// RELIC MENU
{
  menus[20] = new menu(40, 32, 240, 72); // this will be wrong
  menus[20].addItem("relic", "Relic", function() 
  {
    if (menus[19].selection == 0) 
    {
      equipItems(4)
    }
    else 
    {
      removeEquipment(4); 
    }
  }
  );
  menus[20].addItem("relic", "Relic", function() 
  {
    if (menus[19].selection == 0) 
    {
      equipItems(4)
    }
    else 
    {
      removeEquipment(5); 
    }
  }
  );
  menus[20].yOffset = 44;
  menus[20].ySpacing = 12;
  menus[20].before = [function()
  {
    menus[21].draw();
  }
  ];
  menus[20].after = [function()
  {
    menus[18].draw();
  }
  , function()
  {
    menus[20].drawActorStatusEquip(menus[21], 4);
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[20].escapeFunction = function() 
  {
    menus[20].done = true; menus[19].done = false; menus[19].execute(); 
  }
  menus[20].updateItems();
  
  menus[20].lFunction = function()
  { 
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp - 1])
      {
        menus[20].close();
        menus[1].selection = temp - 1;
        return menus[20].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[20].rFunction = function()
  {
    var temp = menus[1].selection;
    
    for (var i = 1; i < 4; i++)
    {
      if (partyA[temp + 1])
      {
        menus[20].close();
        menus[1].selection = temp + 1;
        return menus[20].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// RELIC ITEM MENU
{
  menus[21] = new menu(40, 104, 240, 120);
  menus[21].xOffset = 16;
  menus[21].yOffset = 8;
  menus[21].ySpacing = 12;
  menus[21].cursorXOffset = 24;
  menus[21].after = [function()
  {
    menus[20].draw();
  }
  , function()
  {
    menus[18].draw();
  }
  , function()
  {
    menus[20].drawActorStatusEquip(menus[21], 4);
    drawActorNameFace(220, 56, partyA[menus[1].selection]);
  }
  ];
  menus[21].escapeFunction = function() 
  {
    menus[21].done = true; menus[21].items = []; menus[21].selection = 0; menus[21].topSelection = 0; menus[20].done = false; menus[20].execute(); 
  }
}

// STATUS MENU
{
  menus[22] = new menu(40, 16, 240, 208, "status");
  menus[22].after = [function()
  {
    menus[23].draw();
  }
  ];
  menus[22].escapeFunction = function() 
  {
    menus[22].close(); menus[0].initialize(); 
  }
  menus[22].lFunction = function()
  { 
    var temp = menus[22].actor;
    
    for (var i = 1; i < 4; i++)
    {
      if (menus[22].party[temp - 1])
      {
        menus[22].close();
        menus[22].actor = temp - 1;
        return menus[22].initialize();
      }
      temp--;
      if (i == 3)
      {
        temp = 4;
        i = 1;
      }
    }
  }
  menus[22].rFunction = function()
  {
    var temp = menus[22].actor;
    
    for (var i = 1; i < 4; i++)
    {
      if (menus[22].party[temp + 1])
      {
        menus[22].close();
        menus[22].actor = temp + 1;
        return menus[22].initialize();
      }
      temp++;
      if (i == 3)
      {
        temp = -1;
        i = 1;
      }
    }
  }
}

// STATUS TOP LEFT WINDOW
{
  menus[23] = new windowObject(40, 16, 64, 24, "Status", lightBlue, 8, 8);
}

// CONFIG MENU
{
  menus[24] = new menu(40, 32, 240, 192);
  menus[24].after = [function()
  {
    menus[25].draw();
  }
  ]
  menus[24].escapeFunction = function() 
  {
    menus[24].close(); menus[0].initialize(); 
  }
}

// CONFIG TOP LEFT WINDOW
{
  menus[25] = new windowObject(216, 16, 64, 32, "Config", lightBlue, 8, 13);
}

// SAVE MENU
{
  menus[26] = new menu(40, 24, 240, 200);
  for (var i = 0; i < 3; i++)
  {
    menus[26].addItem("file", undefined, function() 
    {
      saveGame(); 
    }
    );
  }
  menus[26].xOffset = 0;
  menus[26].yOffset = 32;
  menus[26].ySpacing = 56;
  menus[26].escapeFunction = function() 
  {
    menus[26].close(); menus[0].initialize(); 
  }
  menus[26].updateItems();
}

// PARTY RESERVE MENU
{
  menus[27] = new menu(40, 96, 240, 64);
  for (var i = 0; i < 16; i++)
  {
    menus[27].addItem("sprite", "", function() 
    {
      changePartyMembers(27); 
    }
    );
  }
  menus[27].party = partyReserve;
  menus[27].numColumns = 7;
  menus[27].xOffset = 16;
  menus[27].yOffset = 6;
  menus[27].xSpacing = 28;
  menus[27].ySpacing = 28;
  menus[27].cursorXOffset = 16;
  menus[27].before = [function()
  {
    menus[28].draw();
  }
  , function()
  {
    menus[29].draw();
  }
  , function()
  {
    menus[30].draw();
  }
  , function()
  {
    menus[34].draw();
  }
  ];
  menus[27].downFunction = function() 
  {
    partyChangerToParty(); 
  }
  menus[27].updateItems();
  menus[27].escapeFunction = function () 
  {
    partyEscapeFunction(27); 
  }
}

// PARTY CHANGER BACK WINDOW
{
  menus[28] = new windowObject(40, 48, 240, 176);
}

// PARTY CHANGER LINE UP WINDOW
{
  menus[29] = new windowObject(40, 16, 64, 32, "Lineup", lightBlue, 8, 14);
}

// PARTY CHANGER GROUPS WINDOW
{
  menus[30] = new windowObject(104, 16, 176, 32, "Form 1 group(s)", white, 8, 14);
}

// PARTY CHANGER GROUP A MENU
{
  menus[31] = new menu(40, 160, 80, 64);
  for (var i = 0; i < 4; i++)
  {
    menus[31].addItem("sprite", "", function () 
    {
      changePartyMembers(31); 
    }
    );
  }
  menus[31].party = partyA;
  menus[31].xOffset = 16;
  menus[31].yOffset = 6;
  menus[31].xSpacing = 28;
  menus[31].ySpacing = 28;
  menus[31].numColumns = 1;
  menus[31].cursorXOffset = 16;
  menus[31].before = [function()
  {
    menus[28].draw();
  }
  , function()
  {
    menus[29].draw();
  }
  , function()
  {
    menus[30].draw();
  }
  , function()
  {
    menus[27].draw();
  }
  , function()
  {
    menus[34].draw();
  }
  ];
  menus[31].upFunction = function() 
  {
    backToPartyReserve(31, 0); 
  }
  menus[31].updateItems();
  menus[31].escapeFunction = function () 
  {
    partyEscapeFunction(31); 
  }
}

// PARTY CHANGER GROUP B MENU
{
  menus[32] = new menu(120, 160, 80, 64);
  for (var i = 0; i < 4; i++)
  {
    menus[32].addItem("sprite", "", function () 
    {
      changePartyMembers(32); 
    }
    );
  }
  menus[32].party = partyB;
  menus[32].xOffset = 16;
  menus[32].yOffset = 6;
  menus[32].xSpacing = 28;
  menus[32].ySpacing = 28;
  menus[32].numColumns = 1;
  menus[32].cursorXOffset = 16;
  menus[32].before = [function()
  {
    menus[28].draw();
  }
  , function()
  {
    menus[29].draw();
  }
  , function()
  {
    menus[30].draw();
  }
  , function()
  {
    menus[27].draw();
  }
  ];
  menus[32].upFunction = function() 
  {
    backToPartyReserve(32, 3); 
  }
  menus[32].updateItems();
  menus[32].escapeFunction = function () 
  {
    partyEscapeFunction(32); 
  }
}

// PARTY CHANGER GROUP C MENU
{
  menus[33] = new menu(200, 160, 80, 64);
  for (var i = 0; i < 4; i++)
  {
    menus[33].addItem("sprite", "", function () 
    {
      changePartyMembers(33); 
    }
    );
  }
  menus[33].party = partyC;
  menus[33].xOffset = 16;
  menus[33].yOffset = 6;
  menus[33].xSpacing = 28;
  menus[33].ySpacing = 28;
  menus[33].numColumns = 1;
  menus[33].cursorXOffset = 16;
  menus[33].before = [function()
  {
    menus[28].draw();
  }
  , function()
  {
    menus[29].draw();
  }
  , function()
  {
    menus[30].draw();
  }
  , function()
  {
    menus[27].draw();
  }
  ];
  menus[33].upFunction = function() 
  {
    backToPartyReserve(33, 6); 
  }
  menus[33].updateItems();
  menus[33].escapeFunction = function () 
  {
    partyEscapeFunction(33); 
  }
}

// PARTY CHANGER ACTOR DISPLAY
{
  menus[34] = new actorDisplay(menus[27], 40, 48, 240, 56, partyReserve, false, 16, true);
}

// ESPER SUB MENU
{
  menus[35] = new menu(40, 112, 240, 112);
  menus[35].before = [function()
  {
    menus[12].draw();
  }
  ];
  menus[35].after = [function()
  {
    menus[36].draw();
  }
  ];
  menus[35].escapeFunction = function() 
  {
    menus[35].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

// SKILLS SUB MENU
{
  menus[36] = new windowObject(208, 40, 72, 24, "", lightBlue, 8, 8);
}

// ORDER WINDOW
{
  menus[37] = new windowObject(-32, 16, 72, 32, "Order", lightBlue, 16, 13);
}





var num = 3;

function partyChanger()
{
  menus[30].text = "Form " + num + " group(s)";
  switch (num)
  {
    case 1:
    {
      menus[31].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[27].before = [function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[31].draw();
      }];
      break;
    }
    case 2:
    {
      menus[31].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[32].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[32].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[31].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[31].rightFunction = function() 
      {
        menus[31].currentColumn = 0; 
        menus[31].done = true; 
        menus[32].selection = menus[31].selection - 1; 
        menus[31].selection = 0; 
        menus[32].currentColumn = 0; 
        menus[32].done = false; 
        menus[34].menu = menus[32];
        menus[34].party = partyB;
        menus[32].execute(); 
      }
      menus[32].leftFunction = function() 
      {
        menus[32].currentColumn = 0; 
        menus[32].done = true; 
        menus[31].selection = menus[32].selection + 1;
        menus[32].selection = 0; 
        menus[31].currentColumn = menus[31].numColumns; 
        menus[31].done = false; 
        menus[34].menu = menus[31];
        menus[34].party = partyA;
        menus[31].execute() 
      }
      menus[27].before = [function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[31].draw();
      }
      , function()
      {
        menus[32].draw();
      }];
      break;
    }
    case 3:
    {
      menus[31].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[32].draw();
      }
      , function()
      {
        menus[33].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[32].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[31].draw();
      }
      , function()
      {
        menus[33].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[33].before = [function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[27].draw();
      }
      , function()
      {
        menus[31].draw();
      }
      , function()
      {
        menus[32].draw();
      }
      , function()
      {
        menus[34].draw();
      }
      ];
      menus[31].rightFunction = function() 
      {
        menus[31].currentColumn = 0; 
        menus[31].done = true; 
        menus[32].selection = menus[31].selection - 1; 
        menus[31].selection = 0; 
        menus[32].currentColumn = 0; 
        menus[32].done = false; 
        menus[34].menu = menus[32];
        menus[34].party = partyB;
        menus[32].execute(); 
      }
      menus[32].leftFunction = function() 
      {
        menus[32].currentColumn = 0; 
        menus[32].done = true; 
        menus[31].selection = menus[32].selection + 1;
        menus[32].selection = 0; 
        menus[31].currentColumn = menus[31].numColumns; 
        menus[31].done = false; 
        menus[34].menu = menus[31];
        menus[34].party = partyA;
        menus[31].execute() 
      }
      menus[32].rightFunction = function() 
      {
        menus[32].currentColumn = 0; 
        menus[32].done = true; 
        menus[33].selection = menus[32].selection - 1; 
        menus[32].selection = 0; 
        menus[33].currentColumn = 0; 
        menus[33].done = false; 
        menus[34].menu = menus[33];
        menus[34].party = partyC;
        menus[33].execute(); 
      }
      menus[33].leftFunction = function() 
      {
        menus[33].currentColumn = 0; 
        menus[33].done = true; 
        menus[32].selection = menus[33].selection + 1;
        menus[33].selection = 0; 
        menus[32].currentColumn = menus[32].numColumns; 
        menus[32].done = false; 
        menus[34].menu = menus[32];
        menus[34].party = partyB;
        menus[32].execute() 
      }
      menus[27].before = [function()
      {
        menus[30].draw();
      }
      , function()
      {
        menus[28].draw();
      }
      , function()
      {
        menus[29].draw();
      }
      , function()
      {
        menus[31].draw();
      }
      , function()
      {
        menus[32].draw();
      }
      , function()
      {
        menus[33].draw();
      }];
      break;
    }
  }
  menus[27].before[menus[27].before.length] = function()
  {
    menus[34].draw();
  }
  menus[27].done = false;
  menus[27].initialize();
}

function partyEscapeFunction(menu)
{
  menus[menu].close();
}

function partyChangerToParty()
{
  var current = menus[27].selection - 8;
  var next = 0;
  var menu = 0;
  var newSelection = 0;
  
  switch (current)
  {
    case 0:
    {
      next = 0;
      newSelection = 0;
      break;
    }
    case 1:
    {
      next = 1;
      newSelection = 1;
      break;
    }
    case 2:
    {
      next = 1;
      newSelection = 1;
      break;
    }
    case 3:
    {
      next = 2;
      newSelection = 0;
      break;
    }
    case 4:
    {
      next = 3;
      newSelection = 1;
      break;
    }
    case 5:
    {
      next = 4;
      newSelection = 0;
      break;
    }
    case 6:
    {
      next = 5;
      newSelection = 0;
      break;
    }
    case 7:
    {
      next = 5;
      newSelection = 1;
      break;
    }
  }
  if (num < 3)
  {
    if (next >= 4)
    {
      newSelection = 1;
      next -= 2;
    }
  }
  if (num < 2)
  {
    if (next >= 2)
    {
      newSelection = 1;
      next -= 2;
    }
  }
  if (next < 2)
  {
    menus[34].menu = menus[31];
    menus[34].party = partyA;
    menu = 31;
  }
  else if (next >= 2 && next < 4)
  {
    menus[34].menu = menus[32];
    menus[34].party = partyB;
    menu = 32;
  }
  else if (next >= 4)
  {
    menus[34].menu = menus[33];
    menus[34].party = partyC;
    menu = 33;
  }
  menus[27].done = true;
  menus[menu].selection = newSelection;
  menus[menu].currentColumn = newSelection;
  menus[menu].done = false;
  menus[menu].execute();
}

function backToPartyReserve(menu, num)
{
  menus[menu].done = true;
  menus[27].selection = num + 8 + menus[menu].selection;
  menus[27].currentColumn = num + menus[menu].selection;
  menus[27].done = false;
  menus[34].menu = menus[27];
  menus[34].party = partyReserve;
  menus[27].execute();
}

function useItem()
{
  if (pick1 == undefined)
  {
    pick1 = menus[4].selection;
    menus[4].cursorClone = menus[4].selection;
    menus[4].escapeFunction = function() 
    {
      pick1 = undefined; menus[4].cursorClone = undefined; menus[4].escapeFunction = function() 
      {
        menus[4].done = true; menus[5].done = false; menus[5].before = [function()
        {
          menus[4].draw();
        }
        , function()
        {
          menus[6].draw();
        }
        , function() 
        {
          descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
        }
        ]; menus[5].execute(); 
      }
    }
  }
  else
  {
    menus[4].escapeFunction = function() 
    {
      menus[4].done = true; menus[5].done = false; menus[5].before = [function()
      {
        menus[4].draw();
      }
      , function()
      {
        menus[6].draw();
      }
      , function() 
      {
        descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
      }
      ]; menus[5].execute(); 
    }
    var pick2 = menus[4].selection;
    if (partyItems[pick1] != partyItems[pick2])
    {
      var item1 = partyItems[pick1];
      var item2 = partyItems[pick2];
      partyItems[pick1] = item2;
      partyItems[pick2] = item1;
    }
    else
    {
      if (partyItems[pick1] instanceof itemObject)
      {
        drawText(0, 100, "You Will be using " + partyItems[pick1].name);
        FlipScreen();
        GetKey();
      }
      if (partyItems[pick1] instanceof handItemObject || partyItems[pick1] instanceof headItemObject || partyItems[pick1] instanceof bodyItemObject)
      {
        menus[7].done = false;
        menus[7].execute();
      }
    }
    pick1 = undefined;
    menus[4].cursorClone = undefined;
  }
}

function arrange()
{
  var array = [];
  for (var i = 0; i < gameItems.length; i++)
  {
    for (var p = 0; p < partyItems.length; p++)
    {
      if (gameItems[i] == partyItems[p])
      {
        array.push(partyItems[p]);
        break;
      }
    }
  }
  menus[5].before = [function() 
  {
    descriptionWindow.updateDraw(40, 48, 240, 40, menus[4].selection, menus[4].items[menus[4].selection].type, menus[4])
  }
  , function()
  {
    menus[4].draw();
  }
  , function()
  {
    menus[6].draw();
  }
  ];
  menus[4].topSelection = 0;
  menus[4].selection = 0;
  return partyItems = array;
}

function partyPick()
{
  if (partyMenu == false)
  {
    switch(menus[0].selection)
    {
      case 1:
      {
        menus[0].changeAway(true);
        menus[1].close(false);
        return menus[13].initialize();
      }
      case 2:
      {
        menus[0].changeAway(true);
        menus[1].close(false);
        return menus[15].initialize();
      }
      case 3:
      {
        menus[0].changeAway(true);
        menus[1].close(false);
        return menus[19].initialize();
      }
      case 4:
      {
        menus[0].changeAway(true);
        menus[22].party = partyA;
        menus[22].actor = menus[1].selection;
        menus[1].close();
        return menus[22].initialize();
      }
    }
  }
  else
  {
    changePartyMembers(1)
  }
}

function equipItems(i)
{
  menus[17].items = [];
  switch (i)
  {
    case 0:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof handItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem("equipItem", i, function() { swapItem(menus[1].selection, menus[16].selection, partyItems[menus[17].items[menus[17].selection].name], menus[17]); });
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].updateItems();
      menus[17].done = false;
      return menus[17].execute();
    }
    case 1:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof handItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem("equipItem", i, function() { swapItem(menus[1].selection, menus[16].selection, partyItems[menus[17].items[menus[17].selection].name], menus[17]); });
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].updateItems();
      menus[17].done = false;
      return menus[17].execute();
    }
    case 2:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof headItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem("equipItem", i, function() { swapItem(menus[1].selection, menus[16].selection, partyItems[menus[17].items[menus[17].selection].name], menus[17]); });
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].updateItems();
      menus[17].done = false;
      return menus[17].execute();
    }
    case 3:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof bodyItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem("equipItem", i, function() { swapItem(menus[1].selection, menus[16].selection, partyItems[menus[17].items[menus[17].selection].name], menus[17]); });
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].updateItems();
      menus[17].done = false;
      return menus[17].execute();
    }
    case 4:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof relicItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[21].addItem("equipItem", i, function() { swapItem(menus[1].selection, menus[20].selection + 4, partyItems[menus[21].items[menus[21].selection].name], menus[21]); });
            }
          }
        }
      }
      menus[20].done = true;
      menus[21].updateItems();
      menus[21].done = false;
      return menus[21].execute();
    }
  }
}

function optimize(actor)
{
  // Right Hand
  var list = [];
  var actorId = partyA[menus[1].selection].id;
  for (var i = 0; i < partyItems.length; i++)
  {
    if (partyItems[i] instanceof handItemObject)
    {
      for (var p = 0; p < partyItems[i].equip.length; p++)
      {
        if (partyItems[i].equip[p] == actorId)
        {
          list[list.length] = partyItems[i];
        }
      }
    }
  }
      
  var temp = undefined;
  
  for (var i = 0; i < list.length; i++)
  {
    if (temp == undefined && list.length > 0)
    {
      temp = list[i];
    }
    if (temp && temp.batPwr < list[i].batPwr)
    {
      temp = list[i];
    }
  }
  if (temp && actor.equip[0] && actor.equip[0].batPwr < temp.batPwr)
  {
    addItem(actor.equip[0]);
  }
  else if (actor.equip[0] && actor.equip[0].batPwr >= temp.batPwr)
  {
    temp = undefined;
  }
  if (temp)
  {
    removeItem(temp);
    actor.equip[0] = temp;
    temp = undefined;
  }
  
  // Left Hand
  var list = [];
  
  for (var i = 0; i < partyItems.length; i++)
  {
    if (partyItems[i] instanceof handItemObject)
    {
      for (var p = 0; p < partyItems[i].equip.length; p++)
      {
        if (partyItems[i].equip[p] == actorId)
        {
          list[list.length] = partyItems[i];
        }
      }
    }
  }
  
  for (var i = 0; i < list.length; i++)
  {
    if (temp == undefined && list.length > 0)
    {
      temp = list[i];
    }
    if (temp && temp.defence < list[i].defence)
    {
      temp = list[i];
    }
  }
  if (temp && actor.equip[1] && actor.equip[1].defence < temp.defence)
  {
    addItem(actor.equip[1]);
  }
  else if (actor.equip[1] && actor.equip[1].defence >= temp.defence)
  {
    temp = undefined;
  }
  if (temp)
  {
    removeItem(temp);
    actor.equip[1] = temp;
    temp = undefined;
  }
  
  // Head
  var list = [];
  
  for (var i = 0; i < partyItems.length; i++)
  {
    if (partyItems[i] instanceof headItemObject)
    {
      for (var p = 0; p < partyItems[i].equip.length; p++)
      {
        if (partyItems[i].equip[p] == actorId)
        {
          list[list.length] = partyItems[i];
        }
      }
    }
  }
  
  for (var i = 0; i < list.length; i++)
  {
    if (temp == undefined && list.length > 0)
    {
      temp = list[i];
    }
    if (temp && temp.defence < list[i].defence)
    {
      temp = list[i];
    }
  }
  if (temp && actor.equip[2] && actor.equip[2].defence < temp.defence)
  {
    addItem(actor.equip[2]);
  }
  else if (actor.equip[2] && actor.equip[2].defence >= temp.defence)
  {
    temp = undefined;
  }
  if (temp)
  {
    removeItem(temp);
    actor.equip[2] = temp;
    temp = undefined;
  }
  
  // Armour
  var list = [];
  
  for (var i = 0; i < partyItems.length; i++)
  {
    if (partyItems[i] instanceof bodyItemObject)
    {
      for (var p = 0; p < partyItems[i].equip.length; p++)
      {
        if (partyItems[i].equip[p] == actorId)
        {
          list[list.length] = partyItems[i];
        }
      }
    }
  }
  
  for (var i = 0; i < list.length; i++)
  {
    if (temp == undefined && list.length > 0)
    {
      temp = list[i];
    }
    if (temp && temp.defence < list[i].defence)
    {
      temp = list[i];
    }
  }
  if (temp && actor.equip[3] && actor.equip[3].defence < temp.defence)
  {
    addItem(actor.equip[3]);
  }
  else if (actor.equip[3] && actor.equip[3].defence >= temp.defence)
  {
    temp = undefined;
  }
  if (temp)
  {
    removeItem(temp);
    actor.equip[3] = temp;
    temp = undefined;
  }
}

function removeAll(actor)
{
  for (var i = 0; i < 4; i++)
  {
    if (actor.equip[i])
    {
      addItem(actor.equip[i]);
      actor.equip[i] = undefined;
    }
  }
}

function actorCanUseSkill(type, actor)
{
  switch(type)
  {
    case "Espers":
    {
      if (actor.useEspers == true)
      {
        return true;
      }
    }
    case "Magic":
    {
      if (actor.useMagic == true)
      {
        return true;
      }
    }
    case "SwdTech":
    {
      if (actor.useSwdTech == true)
      {
        return true;
      }
    }
    case "Blitz":
    {
      if (actor.useBlitz == true)
      {
        return true;
      }
    }
    case "Lore":
    {
      if (actor.useLore == true)
      {
        return true;
      }
    }
    case "Rage":
    {
      if (actor.useRage == true)
      {
        return true;
      }
    }
    case "Dance":
    {
      if (actor.useDance == true)
      {
        return true;
      }
    }
  }
  return false;
}

function skillsMagic(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillMagic.length; i++)
    {
      menus[10].addItem("magic", "", function() {})
      if (partyA[menus[1].selection].magic[i].learn > 0)
      {
        menus[10].items[menus[10].items.length - 1].description = partyA[menus[1].selection].magic;
      }
    }
    menus[10].cursorXOffset = 24;
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 104;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 1;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[13].done = false; menus[13].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new mpCostWindow(208, 40, 72, 24, partyA[menus[1].selection].magic);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsEspers(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < partyEspers.length; i++)
    {
      menus[10].addItem("esper", "", function() { selectEsper(menus[10].selection) })
      menus[10].items[menus[10].items.length - 1].description = partyEspers;
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[13].done = false; menus[13].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "Espers", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsSwordTech(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillSwordTech.length; i++)
    {
      menus[10].addItem("swordTech", "", function() {});
      menus[10].items[menus[10].items.length - 1].description = partySwordTech;
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "SwdTech", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsBlitz(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillBlitz.length; i++)
    {
      menus[10].addItem("blitz", "", function() {});
      menus[10].items[menus[10].items.length - 1].description = partyBlitz;
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "Blitz", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsLore(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillLore.length; i++)
    {
      menus[10].addItem("lore", "", function() {});
      menus[10].items[menus[10].items.length - 1].description = partyLore;
    }
    menus[10].xOffset = 16;
    menus[10].yOffset = 12;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 0;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "Lore", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsRage(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillRage.length; i++)
    {
      menus[10].addItem("rage", "", function() {});
      menus[10].items[menus[10].items.length - 1].description = partyRage;
    }
    menus[10].xOffset = 32;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 0;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "Rage", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function skillsDance(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillDance.length; i++)
    {
      menus[10].addItem("dance", "", function() {});
      menus[10].items[menus[10].items.length - 1].description = partyDance;
    }
    menus[10].xOffset = 16;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].topSelection = 0;
    menus[10].escapeFunction = function() { descriptionWindow.text = ""; menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].updateItems();
    menus[36] = new windowObject(208, 40, 72, 24, "Dance", lightBlue, 8, 8);
    menus[10].changeAway(true);
    menus[10].changeTo();
  }
}

function saveGame()
{
  var file = OpenFile("File " + menus[26].selection);
  file.write("Empty", false);
  
  for (var i = 0; i < partyA.length; i++)
  {
    if (partyA[i])
    {
      file.write("name", partyA[i].name);
      file.write("hp", partyA[i].hp);
      file.write("maxHp", partyA[i].maxHp);
      file.write("lv", partyA[i].level);
      file.write("id", partyA[i].id);
      break;
    }
  }
  for (var i = 0; i < partyA.length; i++)
  {
    if (partyA[i]) { file.write("pos" + i, partyA[i].id); }
    else { file.write("pos" + i, undefined); }
  }
  
  file.write("time", gameClock.getTime());
  file.write("gp", gp);
  file.write("steps", steps);
  file.write("map", GetCurrentMap());
  file.write("x", GetPersonX("Player"));
  file.write("y", GetPersonY("Player"));
  file.write("dir", GetPersonDirection("Player"));
  
  // Need to make seperate parties for multi party selection parts of the game - ie the party changer so that we dont lose those actors
  // Also need to make a seperate arrat for reserve members who are not in use so that we do not lose them either
  // Finally a back up array for actors that are unused, for temporary characters and whatknot
  
  // Then we need to save all of they're statistics, equipment, magic etc
  
  // Save all of the party Skills, keeping in mind the terms of gogo being able to use these skills
  
  // Save all of the items the party has
  
  // Recode the game function to handle the load menu
  
  // Then make a rework to save switches to handle events etc.
  
  // Then that should be it
}

function removeEquipment(i)
{
  if (partyA[menus[1].selection].equip[i] != undefined)
  {
    if (i < 4)
    {
      log.write("Try to un-equip item");
      var item = partyA[menus[1].selection].equip[i];
      partyA[menus[1].selection].equip[i] = undefined;
      addItem(item);
    } 
    else
    {
      log.write("Try to un-equip relic");
      var item = partyA[menus[1].selection].equip[i];
      partyA[menus[1].selection].equip[i] = undefined;
      addItem(item);
    }
  }
  else
  {
    log.write("Couldnt remove item because there is no item to remove");
  }
}

function swapItem(person, equip, item, menuA)
{
  log.write("Try to equip item");
  var currentItem = partyA[person].equip[equip];
  if (currentItem != undefined)
  {
    addItem(currentItem);
  }
  removeItem(item);
  partyA[person].equip[equip] = item;
  menuA.escapeFunction();
}

var partyChangeA = undefined;
var partyChangePartyA = undefined;
var partyChangeB = undefined;
var partyChangePartyB = undefined;

function changePartyMembers(menu)
{
  if (partyChangeA == undefined)
  {
    partyChangeA = menus[menu].selection;
    partyChangePartyA = menus[menu].party;  
  }
  else
  {
    var partyChangeB = menus[menu].selection;
    partyChangePartyB = menus[menu].party;
    
    if (partyChangeA == partyChangeB && partyChangePartyA == partyChangePartyB)
    {
      if (partyMenu == true)
      {
        changeRow(partyChangePartyA[partyChangeA], menu);
      }
      else
      {
        for (var i = 0; i < 10; i++)
        {
          menus[menu].render();
          Rectangle(0, 0, 320, 240, CreateColor(0,0,0,0 + (i * (255 / 10))));
          FlipScreen();
        }
        
        menus[22].party = partyChangePartyA;
        menus[22].actor = partyChangeA;
        
        for (var i = 0; i < 10; i++)
        {
          menus[22].render();
          Rectangle(0, 0, 320, 240, CreateColor(0,0,0,255 - (i * (255 / 10))));
          FlipScreen();
        }
        
        menus[22].render();
        FlipScreen();
        GetKey();
        
        for (var i = 0; i < 10; i++)
        {
          menus[22].render();
          Rectangle(0, 0, 320, 240, CreateColor(0,0,0,0 + (i * (255 / 10))));
          FlipScreen();
        }
        
        menus[22].actor = partyChangePartyA[partyChangeA];
        
        for (var i = 0; i < 10; i++)
        {
          menus[menu].render();
          Rectangle(0, 0, 320, 240, CreateColor(0,0,0,255 - (i * (255 / 10))));
          FlipScreen();
        }
        clearKeyQueue();
      }
    }
    else
    {
      this.actorA = partyChangeA;
      this.actorB = partyChangeB;
      
      if (partyMenu && this.actorA > this.actorB)
      {
        var temp = this.actorA;
        this.actorA = this.actorB;
        this.actorB = temp;
      }
      
      if (partyMenu)
      {
        partyChangePartyA[this.actorA].state = "closeDown";
        partyChangePartyB[this.actorB].state = "closeUp";
        
        for (var i = 0; i < 6; i++)
        {
          partyChangePartyA[this.actorA].close += (40 / 6);
          partyChangePartyB[this.actorB].close += (40 / 6);
          menus[1].render();
          menus[1].border();
          FlipScreen();
        }
      }
      
      var item1 = partyChangePartyA[this.actorA];
      var item2 = partyChangePartyB[this.actorB];
      partyChangePartyA[this.actorA] = item2;
      partyChangePartyB[this.actorB] = item1;
      
      if (partyMenu)
      {
        partyChangePartyA[this.actorA].state = "openDown";
        partyChangePartyB[this.actorB].state = "openUp";
        
        for (var i = 0; i < 6; i++)
        {
          partyChangePartyA[this.actorA].close -= (40 / 6);
          partyChangePartyB[this.actorB].close -= (40 / 6);
          menus[1].render();
          menus[1].border();
          FlipScreen();
        }
        
        partyChangePartyA[this.actorA].state = undefined;
        partyChangePartyB[this.actorB].state = undefined;
      }
    }
    this.actorA = undefined;
    this.actorB = undefined;
    partyChangeA = undefined;
    partyChangePartyA = undefined;
    partyChangeB = undefined;
    partyChangePartyB = undefined;
  }
  clearKeyQueue();
}

function delay(milliseconds)
{
  var start = GetTime();
  while (start + milliseconds > GetTime()) {
  }
}

function equipEsper(esper)
{
  if (!partyEspers[menus[10].selection].equipTo)
  {
    if (partyA[menus[1].selection].esper)
    {
      for (var i = 0; i < partyEspers.length; i++)
      {
        if (partyEspers[i].name == partyA[menus[1].selection].esper.name)
        {
          partyEspers[i].equipTo = undefined;
        }
      }
    }
    esper.equipTo = partyA[menus[1].selection];
    partyA[menus[1].selection].esper = esper;
    menus[35].escapeFunction();
  }
  else
  {
    menus[35].render();
    drawWindow(40, 16, 240, 40);
    drawText(48, 24, esper.equipTo.name + " has it!");
    FlipScreen();
    delay(500);
    menus[35].escapeFunction();
    clearKeyQueue();
  }
}

function selectEsper(esper)
{
  if (partyEspers[esper])
  {
    menus[10].done = true;
    menus[35].xOffset = 32;
    menus[35].yOffset = 12;
    menus[35].ySpacing = 12;
    menus[35].cursorXOffset = 48;
    menus[35].items = [];
    menus[35].addItem("esperSub", partyEspers[esper].name, function() { equipEsper(partyEspers[esper]) } );
    menus[35].items[menus[35].items.length - 1].info = partyEspers[esper].info;
    for (var i = 0; i < 5; i++)
    {
      if (partyEspers[esper].spells[i])
      {
        menus[35].addEsperSpell(partyEspers[esper].spells[i], partyEspers[esper].spells[i].spell, function() {} );
        menus[35].items[menus[35].items.length - 1].info = skillMagic[partyEspers[esper].spells[i].spell].info;
      }
      else
      {
        menus[35].addItem("text", "", function() {} );
        menus[35].items[menus[35].items.length - 1].info = "";
      }
    }
    if (partyEspers[esper].levelUp != "")
    {
      menus[35].addItem("text", "At level up. . ." + partyEspers[esper].levelUp, function() {} );
      menus[35].items[menus[35].items.length - 1].info = "TEXT WILL GO HERE " + "at level up";
    }
    else
    {
      menus[35].addItem("text", "", function() {} );
    }
    
    menus[35].functions[menus[35].functions.length] = function() { 
    descriptionWindow.updateDraw(40, 16, 240, 40, menus[35].selection, menus[35].items, menus[35]); }
    //Abort(menus[35].functions[0])
    menus[35].updateItems();
    menus[35].items[0].x -= 8
    menus[35].done = false;
    menus[35].execute();
  }
}